"""
HB_CleanView V1.3

Last Modified: 6/28/2017
Works with CINEMA 4D R16.050 and up.

Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_CleanView

Description-US: Changes Displayfilters to show only stuff that is relevant for modelling [SHIFT-Click: Show only Geometry]

Usage:
Click once to activate CleanView. A Null will be Created to indicate that CleanView is active. (Please dont delete this Object). Clicking once again will turn
off Cleanview and delete this Null and restore all Settings you had before. If you Shift-Click the Script will only show Geommetry and nothing else. This is especially good for making hardware renderings.

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=34m34s

Name-DE: HB_CleanView
Description-DE: Ändert Displayfilter so dass nur Modelling relevante sachen sichtbar sind. [SHIFT-Click: Cleans up the View even more]


ChangeLog:
Jun/11/2015 V1.0 
-Release Version

Jan/1/2016 V1.1
-Bugfixes

Jun/28/2017 V1.2
- Default Material does not change color anymore

Oct/11/2018 V1.3
- New Highres Icon
- Axisbands don´t get hidden

"""

import c4d

def main():
    
    CLEANVIEW=1050264
    
    #TOGGLE STATE
    mysettings_bc = c4d.plugins.GetWorldPluginData(CLEANVIEW)
    if not mysettings_bc:
        mysettings_bc = c4d.GetWorldContainerInstance()
        mysettings_bc.SetData(999, False)
  
    ToggleState=mysettings_bc.GetData(999)

    if ToggleState == True:

        mysettings_bc.SetData(999, False)
        ToggleState=mysettings_bc.GetData(999)
    else:
        
        mysettings_bc.SetData(999, True)
        ToggleState=mysettings_bc.GetData(999)
        
    c4d.plugins.SetWorldPluginData(CLEANVIEW, mysettings_bc)
    drawBD = doc.GetActiveBaseDraw()
    
    c4dVersion= c4d.GetC4DVersion()
    bc = c4d.BaseContainer()
    
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc)
        
    turbo=False
    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 :
        turbo=True



    if ToggleState==False:
        
        
        
        
        mysettings_bc.SetData(1, drawBD[c4d.BASEDRAW_DISPLAYFILTER_NULL])
        mysettings_bc.SetData(2, drawBD[c4d.BASEDRAW_DISPLAYFILTER_SPLINE])
        mysettings_bc.SetData(3, drawBD[c4d.BASEDRAW_DISPLAYFILTER_HYPERNURBS])
        mysettings_bc.SetData(4, drawBD[c4d.BASEDRAW_DISPLAYFILTER_DEFORMER])
        mysettings_bc.SetData(5, drawBD[c4d.BASEDRAW_DISPLAYFILTER_LIGHT])
        mysettings_bc.SetData(6, drawBD[c4d.BASEDRAW_DISPLAYFILTER_PARTICLE])
        mysettings_bc.SetData(7, drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRID])
        mysettings_bc.SetData(8, drawBD[c4d.BASEDRAW_DISPLAYFILTER_HORIZON])
        mysettings_bc.SetData(9, drawBD[c4d.BASEDRAW_DISPLAYFILTER_BOUNDS])
        mysettings_bc.SetData(10, drawBD[c4d.BASEDRAW_DISPLAYFILTER_SDS])
        mysettings_bc.SetData(11, drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHIGHLIGHTING])
        mysettings_bc.SetData(12, drawBD[c4d.BASEDRAW_DISPLAYFILTER_MULTIAXIS])
        mysettings_bc.SetData(13, drawBD[c4d.BASEDRAW_DISPLAYFILTER_HANDLEBANDS])
        mysettings_bc.SetData(14, drawBD[c4d.BASEDRAW_DISPLAYFILTER_NGONLINES])
        mysettings_bc.SetData(15, drawBD[c4d.BASEDRAW_DISPLAYFILTER_GUIDELINES])
        mysettings_bc.SetData(16, drawBD[c4d.BASEDRAW_DISPLAYFILTER_POI])
        mysettings_bc.SetData(17, drawBD[c4d.BASEDRAW_DISPLAYFILTER_POLYGON])
        mysettings_bc.SetData(18, drawBD[c4d.BASEDRAW_DISPLAYFILTER_GENERATOR])
        mysettings_bc.SetData(19, drawBD[c4d.BASEDRAW_DISPLAYFILTER_JOINT])
        mysettings_bc.SetData(20, drawBD[c4d.BASEDRAW_DISPLAYFILTER_CAMERA])
        mysettings_bc.SetData(21, drawBD[c4d.BASEDRAW_DISPLAYFILTER_SCENE])
        mysettings_bc.SetData(22, drawBD[c4d.BASEDRAW_DISPLAYFILTER_OTHER])
        if c4dVersion >= 16000:
            mysettings_bc.SetData(23, drawBD[c4d.BASEDRAW_DISPLAYFILTER_BASEGRID])
        mysettings_bc.SetData(24, drawBD[c4d.BASEDRAW_DISPLAYFILTER_WORLDAXIS])
        mysettings_bc.SetData(25, drawBD[c4d.BASEDRAW_DISPLAYFILTER_HUD])
        mysettings_bc.SetData(26, drawBD[c4d.BASEDRAW_DISPLAYFILTER_HIGHLIGHTING])
        mysettings_bc.SetData(27, drawBD[c4d.BASEDRAW_DISPLAYFILTER_HIGHLIGHTING_HANDLES])
        mysettings_bc.SetData(28, drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHANDLES])
        mysettings_bc.SetData(29, drawBD[c4d.BASEDRAW_DISPLAYFILTER_SDSCAGE])
        mysettings_bc.SetData(30, drawBD[c4d.BASEDRAW_DISPLAYFILTER_ONION])
        mysettings_bc.SetData(31, drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRADIENT])
      
      
       
        mysettings_bc.SetData(32, doc[c4d.DOCUMENT_DEFAULTMATERIAL_TYPE])
        mysettings_bc.SetData(33, c4d.GetViewColor(c4d.VIEWCOLOR_C4DBACKGROUND))
        mysettings_bc.SetData(34, drawBD[c4d.BASEDRAW_DATA_SHOWSAFEFRAME])
        mysettings_bc.SetData(35, doc[c4d.DOCUMENT_DEFAULTMATERIAL_COLOR])
        
        
        
        c4d.plugins.SetWorldPluginData(CLEANVIEW, mysettings_bc)
     
        if turbo:
            if c4dVersion >= 16000:
                drawBD[c4d.BASEDRAW_DISPLAYFILTER_BASEGRID]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRID]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_DEFORMER]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_HUD]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_GUIDELINES]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_MULTIAXIS]=False
            #drawBD[c4d.BASEDRAW_DISPLAYFILTER_HANDLEBANDS]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHANDLES]=False
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_SPLINE]=False
            
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRADIENT]=False
        else:
            if c4dVersion >= 16000:
                drawBD[c4d.BASEDRAW_DISPLAYFILTER_BASEGRID]=True
            
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_DEFORMER]=True
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_HUD]=True
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_GUIDELINES]=True      
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_MULTIAXIS]=True
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_HANDLEBANDS]=True
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHANDLES]=True
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_SPLINE]=True
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRADIENT]=True
        
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_WORLDAXIS]=False    
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_NULL]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRID]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HYPERNURBS]=True
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_LIGHT]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_PARTICLE]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HORIZON]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_BOUNDS]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SDS]=True
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHIGHLIGHTING]=False   
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_NGONLINES]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_POI]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_POLYGON]=True
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_GENERATOR]=True
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_JOINT]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_CAMERA]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SCENE]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_OTHER]=False     
           
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HIGHLIGHTING]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HIGHLIGHTING_HANDLES]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SDSCAGE]=False
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_ONION]=False

        c4d.SetViewColor(c4d.VIEWCOLOR_C4DBACKGROUND,c4d.utils.HSVToRGB(c4d.Vector(0,0,0.15)))
        drawBD[c4d.BASEDRAW_DATA_SHOWSAFEFRAME]=False
        c4d.EventAdd()

    if ToggleState == True:
 
        DISPLAYbc = c4d.plugins.GetWorldPluginData(CLEANVIEW)
        
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_NULL]=DISPLAYbc.GetData(1)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SPLINE]=DISPLAYbc.GetData(2)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HYPERNURBS]=DISPLAYbc.GetData(3)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_DEFORMER]=DISPLAYbc.GetData(4)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_LIGHT]=DISPLAYbc.GetData(5)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_PARTICLE]=DISPLAYbc.GetData(6)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRID]=DISPLAYbc.GetData(7)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HORIZON]=DISPLAYbc.GetData(8)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_BOUNDS]=DISPLAYbc.GetData(9)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SDS]=DISPLAYbc.GetData(10)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHIGHLIGHTING]=DISPLAYbc.GetData(11)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_MULTIAXIS]=DISPLAYbc.GetData(12)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HANDLEBANDS]=DISPLAYbc.GetData(13)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_NGONLINES]=DISPLAYbc.GetData(14)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_GUIDELINES]=DISPLAYbc.GetData(15)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_POI]=DISPLAYbc.GetData(16)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_POLYGON]=DISPLAYbc.GetData(17)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_GENERATOR]=DISPLAYbc.GetData(18)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_JOINT]=DISPLAYbc.GetData(19)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_CAMERA]=DISPLAYbc.GetData(20)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SCENE]=DISPLAYbc.GetData(21)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_OTHER]=DISPLAYbc.GetData(22)
        if c4dVersion >= 16000:
            drawBD[c4d.BASEDRAW_DISPLAYFILTER_BASEGRID]=DISPLAYbc.GetData(23)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_WORLDAXIS]=DISPLAYbc.GetData(24)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HUD]=DISPLAYbc.GetData(25)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HIGHLIGHTING]=DISPLAYbc.GetData(26)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_HIGHLIGHTING_HANDLES]=DISPLAYbc.GetData(27)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_OBJECTHANDLES]=DISPLAYbc.GetData(28)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SDSCAGE]=DISPLAYbc.GetData(29)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_ONION]=DISPLAYbc.GetData(30)
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_GRADIENT]=DISPLAYbc.GetData(31)
        
        #doc[c4d.DOCUMENT_DEFAULTMATERIAL_TYPE]=DISPLAYbc.GetData(32)
        c4d.SetViewColor(c4d.VIEWCOLOR_C4DBACKGROUND,DISPLAYbc.GetData(33))
        drawBD[c4d.BASEDRAW_DATA_SHOWSAFEFRAME]=DISPLAYbc.GetData(34)
        #doc[c4d.DOCUMENT_DEFAULTMATERIAL_COLOR]=DISPLAYbc.GetData(35)
       
        
            
            
if __name__=='__main__':
    main()
    c4d.EventAdd()
